<?php 
 
class WordReplacerSettings extends WordReplacerAdmin { 
    public function __construct($word_replacer_api, $word_replacer_db, $word_replacer_content_processor) { 
        parent::__construct($word_replacer_api, $word_replacer_db, $word_replacer_content_processor); 
        $this->add_settings_page(); 
    } 
 
    private function add_settings_page() { 
        add_action('admin_menu', array($this, 'register_settings_page')); 
        add_action('admin_init', array($this, 'register_settings'));
        add_action('admin_head', array($this, 'add_custom_styles')); 
    } 
 
    public function register_settings_page() { 
        add_submenu_page( 
            'word-replacer', 
            'Adverlink Settings', 
            'Adverlink Settings', 
            'manage_options', 
            'word-replacer-settings', 
            array($this, 'render_settings_page') 
        ); 
    } 
 
    public function register_settings() { 
        register_setting('word-replacer-settings', 'word_replacer_disable_cron'); 
    
        add_settings_section( 
            'word-replacer-settings-section', 
            'General Settings', 
            array($this, 'word_replacer_settings_section_callback'), 
            'word-replacer-settings' 
        ); 
    
        add_settings_field( 
            'word_replacer_disable_cron', 
            '', // Empty title since we're handling it in the callback
            array($this, 'word_replacer_disable_cron_callback'), 
            'word-replacer-settings', 
            'word-replacer-settings-section',
            ['class' => 'word-replacer-field'] // Add a class for custom styling
        ); 
    } 
     
    public function word_replacer_settings_section_callback() { 
        echo 'Configure the Adverlink plugin settings.'; 
    } 

    public function add_custom_styles() {
        ?>
        <style>
            /* Remove default WordPress admin styles that might affect alignment */
            .word-replacer-field th {
                display: none;
            }
            
            .word-replacer-field td {
                padding-left: 0;
                margin-left: 0;
            }
    
            .word-replacer-container {
                margin-left: 0;
                padding-left: 0;
            }
    
            .toggle-button {
                position: relative;
                display: inline-flex;
                height: 24px;
                width: 44px;
                align-items: center;
                border-radius: 12px;
                transition-property: background-color;
                transition-duration: 200ms;
                transition-timing-function: ease-in-out;
                cursor: pointer;
                border: 1px solid #d1d5db;
                margin-left: 0;
            }
    
            .toggle-button:focus {
                outline: none;
                box-shadow: 0 0 0 2px rgba(96, 165, 250, 0.5);
            }
    
            .toggle-button.toggled {
                background-color: #2563eb;
            }
    
            .toggle-button.untoggled {
                background-color: #f3f4f6;
            }
    
            .toggle-button-circle {
                display: inline-block;
                height: 18px;
                width: 18px;
                transform: translateX(3px);
                border-radius: 9999px;
                background-color: white;
                box-shadow: 0 1px 2px 0 rgb(0 0 0 / 0.1);
                transition-property: transform;
                transition-duration: 200ms;
                transition-timing-function: ease-in-out;
            }
    
            .toggled .toggle-button-circle {
                transform: translateX(23px);
            }
    
            .screen-reader-text {
                border: 0;
                clip: rect(1px, 1px, 1px, 1px);
                clip-path: inset(50%);
                height: 1px;
                margin: -1px;
                overflow: hidden;
                padding: 0;
                position: absolute;
                width: 1px;
                word-wrap: normal !important;
            }
        </style>
        <?php
    }

    public function word_replacer_disable_cron_callback() { 
        $disable_cron = get_option('word_replacer_disable_cron', true);
        ?>
        <div class="word-replacer-container">
            <div style="font-weight: 600;">Manual Link Management</div>
            <p style="color: #666; font-style: italic; margin: 0 0 8px 0; white-space: nowrap;">
                ⚠️ By disabling this option, automatic link insertion will be activated, and manual link management will be disabled. Links will be added automatically without your intervention
            </p>
            <button type="button" 
                    class="toggle-button <?php echo $disable_cron ? 'toggled' : 'untoggled' ?>"
                    onclick="toggleCron(this)">
                <span class="screen-reader-text"><?php echo $disable_cron ? 'Enable' : 'Disable' ?></span>
                <span class="toggle-button-circle"></span>
            </button>
            <input type="hidden" name="word_replacer_disable_cron" value="<?php echo $disable_cron ? '1' : '0' ?>" id="cron-toggle-value">
        </div>
        <script>
        function toggleCron(button) {
            button.classList.toggle('toggled');
            button.classList.toggle('untoggled');
            const isToggled = button.classList.contains('toggled');
            document.getElementById('cron-toggle-value').value = isToggled ? '1' : '0';
            const srOnly = button.querySelector('.screen-reader-text');
            srOnly.textContent = isToggled ? 'Enable' : 'Disable';
        }
        </script>
        <?php
    } 
 
    public function render_settings_page() { 
        echo '<div class="wrap">'; 
        echo '<h1>Adverlink Settings</h1>'; 
        echo '<form method="post" action="options.php">'; 
        settings_fields('word-replacer-settings'); 
        do_settings_sections('word-replacer-settings'); 
        submit_button(); 
        echo '</form>'; 
        echo '</div>'; 
    } 
}