<?php
class WordReplacerAPI {
    //TODO change hardcoded api
    private $api_base_url = 'https://adverlinkstaging-frajdnh7cne2dpc7.eastus2-01.azurewebsites.net';

    public function postLog($logEntry) {
        $endpoint = $this->api_base_url . '/api/logging';
        $response = wp_remote_post($endpoint, array(
            'method'    => 'POST',
            'body'      => json_encode($logEntry),
            'headers'   => array(
                'Content-Type' => 'application/json'
            )
        ));

        if (is_wp_error($response)) {
            $error_message = $response->get_error_message();
            return "Something went wrong: $error_message";
        }

        return wp_remote_retrieve_body($response);
    }

    public function verify_secret_key($secret_key) {
        $domainFromWordpress = parse_url(home_url(), PHP_URL_HOST);
        // Step 1: Verify the secret key
        $response = wp_remote_post($this->api_base_url . '/api/User/fetchUserId', [
            'body' => json_encode(['secretKey' => $secret_key, 'domainFromWordpress' => $domainFromWordpress]), // Send domain as well
            'headers' => ['Content-Type' => 'application/json'],
        ]);
    
        // Log the API request for fetching user ID
        // $log_data = array(
        //     'secret_key' => $secret_key,
        //     'api_url' => $this->api_base_url . '/api/User/fetchUserId',
        //     'request_body' => json_encode(['secretKey' => $secret_key]),
        // );
        // $logEntry = array(
        //     'Source' => 'php-plugin',
        //     'Level' => 'Info',
        //     'Action' => 'fetch_user_id_request',
        //     'JsonData' => json_encode($log_data),
        //     'UserId' => null,  // We don't have the userId yet
        //     'AdditionalInfo' => 'Request to fetch user ID initiated'
        // );
        // $this->postLog($logEntry);
    
        if (is_wp_error($response)) {
            // Log the error
            // $logEntry['Level'] = 'Error';
            // $logEntry['Action'] = 'fetch_user_id_error';
            // $logEntry['AdditionalInfo'] = 'Error occurred while fetching user ID';
            // $this->postLog($logEntry);
    
            return false;
        }
    
        $body = wp_remote_retrieve_body($response);
        $data = json_decode($body, true);
    
        // Log the API response for fetching user ID
        // $log_data['response_body'] = $body;
        // $logEntry['JsonData'] = json_encode($log_data);
        // $logEntry['Action'] = 'fetch_user_id_response';
        // $logEntry['AdditionalInfo'] = 'Response received for fetch user ID request';
        // $this->postLog($logEntry);
    
        // Check if userId is present
        if (!isset($data['userId'])) {
            // Log the missing user ID
            // $logEntry['Level'] = 'Warning';
            // $logEntry['Action'] = 'user_id_not_found';
            // $logEntry['AdditionalInfo'] = 'User ID not found in response';
            // $this->postLog($logEntry);
    
            return false;
        }
    
        // Step 2: Update the IsActivated status
        $update_response = wp_remote_request($this->api_base_url . '/api/UserDomains/update-secret-key-activated', [
            'method' => 'PUT',
            'body' => json_encode(['Key' => $secret_key]),
            'headers' => ['Content-Type' => 'application/json'],
        ]);
    
        // Log the API request for updating the secret key status
        // $log_data = array(
        //     'secret_key' => $secret_key,
        //     'api_url' => $this->api_base_url . '/api/UserDomains/update-secret-key-activated',
        //     'request_body' => json_encode(['Key' => $secret_key]),
        // );
        // $logEntry['Action'] = 'update_secret_key_request';
        // $logEntry['JsonData'] = json_encode($log_data);
        // $logEntry['UserId'] = $data['userId'];  // Now we have the user ID
        // $logEntry['AdditionalInfo'] = 'Request to update secret key status initiated';
        // $this->postLog($logEntry);
    
        if (is_wp_error($update_response)) {
            // Log the error
            // $logEntry['Level'] = 'Error';
            // $logEntry['Action'] = 'update_secret_key_error';
            // $logEntry['AdditionalInfo'] = 'Error occurred while updating secret key status';
            // $this->postLog($logEntry);
    
            return false;
        }
    
        $update_body = wp_remote_retrieve_body($update_response);
        $update_data = json_decode($update_body, true);
    
        // Log the API response for updating the secret key status
        // $log_data['response_body'] = $update_body;
        // $logEntry['Action'] = 'update_secret_key_response';
        // $logEntry['JsonData'] = json_encode($log_data);
        // $logEntry['AdditionalInfo'] = 'Response received for update secret key request';
        // $this->postLog($logEntry);
    
        //TODO: "if" did not work
        // Check if the update was successful 
        // if (isset($update_data['success']) && $update_data['success'] === true) {
            return $data['userId'];
        // } else {
        //     // Log the failed update
        //     $logEntry['Level'] = 'Error';
        //     $logEntry['Action'] = 'update_secret_key_failed';
        //     $logEntry['AdditionalInfo'] = 'Update secret key status failed';
        //     $this->api->postLog($logEntry);
    
        //     return false;
        // }
    }
    public function get_word_and_link($user_id, $secret_key) {
        $secret_key = get_option('word_replacer_secret_key');
        if (!$secret_key) {
            return ['error' => 'No secret key found'];
        }
    
        $url = $this->api_base_url . "/api/WordToLink/User/{$user_id}/{$secret_key}/forPlugin";
    
        // Set timeout parameters
        $args = array(
            'timeout' => 60,    // Increase timeout to 30 seconds
            'httpversion' => '1.1',
            'blocking' => true, // Make sure the request is blocking
            'sslverify' => true,
            'headers' => array(
                'Accept' => 'application/json'
            )
        );
    
        // Make the API request with custom arguments
        $response = wp_remote_get($url, $args);
    
        // Check for timeouts and other errors
        if (is_wp_error($response)) {
            $error_message = $response->get_error_message();
            if (strpos($error_message, 'timeout') !== false) {
                return ['error' => 'Request timed out. Please try again later.'];
            }
            return ['error' => 'WP Error: ' . $error_message];
        }
    
        $response_code = wp_remote_retrieve_response_code($response);
        
        // Check for non-200 response codes
        if ($response_code !== 200) {
            return ['error' => 'API returned error code: ' . $response_code];
        }
    
        $body = wp_remote_retrieve_body($response);
        $data = json_decode($body, true);
    
        if (empty($data)) {
            return ['error' => 'Empty response from API. Response code: ' . $response_code];
        }
    
        return $data;
    }
    public function get_word_and_link_for_Replace_Cron($user_id, $secret_key) {
        $secret_key = get_option('word_replacer_secret_key');
        if (!$secret_key) {
            // $logEntry = [
            //     'Source' => 'php-plugin',
            //     'Level' => 'Error',
            //     'Action' => 'get_word_and_link_no_secret_key',
            //     'JsonData' => json_encode(['userId' => $user_id]),
            //     'AdditionalInfo' => 'No secret key found in options',
            // ];
            // $this->postLog($logEntry);
            return ['error' => 'No secret key found'];
        }
    
        $url = $this->api_base_url . "/api/WordToLink/User/{$user_id}/{$secret_key}/forReplaceCron";
        error_log('apiurl replacecron : ' . print_r($url, true));
        // $logEntry = [
        //     'Source' => 'php-plugin',
        //     'Level' => 'Info',
        //     'Action' => 'get_word_and_link_request',
        //     'JsonData' => json_encode(['userId' => $user_id, 'api_url' => $url]),
        //     'AdditionalInfo' => 'Calling API to get word and link data',
        // ];
        // $this->postLog($logEntry);
    
        $response = wp_remote_get($url);
    
        if (is_wp_error($response)) {
            $error_message = $response->get_error_message();
            // $logEntry['Level'] = 'Error';
            // $logEntry['Action'] = 'get_word_and_link_error';
            // $logEntry['AdditionalInfo'] = 'Error occurred while fetching word and link data: ' . $error_message;
            // $this->postLog($logEntry);
            return ['error' => 'WP Error: ' . $error_message];
        }
    
        $body = wp_remote_retrieve_body($response);
        $data = json_decode($body, true);
    
        if (empty($data)) {
            $response_code = wp_remote_retrieve_response_code($response);
            // $logEntry['Level'] = 'Warning';
            // $logEntry['Action'] = 'get_word_and_link_empty_response';
            // $logEntry['AdditionalInfo'] = 'Empty response from API. Response code: ' . $response_code;
            // $this->postLog($logEntry);
            return ['error' => 'Empty response from API. Response code: ' . $response_code];
        }
    
        // $logEntry['Level'] = 'Info';
        // $logEntry['Action'] = 'get_word_and_link_response';
        // $logEntry['JsonData'] = json_encode(['response_body' => $data]);
        // $logEntry['AdditionalInfo'] = 'Received response for word and link API request';
        // $this->postLog($logEntry);
    
        return $data;
    }

    public function get_Plugin_Status() {
        $version = WORD_REPLACER_VERSION;
        $domain = parse_url(get_site_url(), PHP_URL_HOST);
        $url = $this->api_base_url . "/api/WordToLink/PluginStatus/{$version}/{$domain}";
    
        $response = wp_remote_get($url);
    
        if (is_wp_error($response)) {
            $error_message = $response->get_error_message();
            // $logEntry['Level'] = 'Error';
            // $logEntry['Action'] = 'get_word_and_link_error';
            // $logEntry['AdditionalInfo'] = 'Error occurred while fetching word and link data: ' . $error_message;
            // $this->postLog($logEntry);
            return ['error' => 'WP Error: ' . $error_message];
        }
    
        $body = wp_remote_retrieve_body($response);
        $data = json_decode($body, true);
    
        if (empty($data)) {
            $response_code = wp_remote_retrieve_response_code($response);
            // $logEntry['Level'] = 'Warning';
            // $logEntry['Action'] = 'get_word_and_link_empty_response';
            // $logEntry['AdditionalInfo'] = 'Empty response from API. Response code: ' . $response_code;
            // $this->postLog($logEntry);
            return ['error' => 'Empty response from API. Response code: ' . $response_code];
        }
    
        // $logEntry['Level'] = 'Info';
        // $logEntry['Action'] = 'get_word_and_link_response';
        // $logEntry['JsonData'] = json_encode(['response_body' => $data]);
        // $logEntry['AdditionalInfo'] = 'Received response for word and link API request';
        // $this->postLog($logEntry);
    
        return $data;
    }

    public function get_word_and_link_for_Revert_Cron($user_id, $secret_key) {
        $secret_key = get_option('word_replacer_secret_key');
        if (!$secret_key) {
            // $logEntry = [
            //     'Source' => 'php-plugin',
            //     'Level' => 'Error',
            //     'Action' => 'get_word_and_link_no_secret_key',
            //     'JsonData' => json_encode(['userId' => $user_id]),
            //     'AdditionalInfo' => 'No secret key found in options',
            // ];
            // $this->postLog($logEntry);
            return ['error' => 'No secret key found'];
        }
    
        $url = $this->api_base_url . "/api/WordToLink/User/{$user_id}/{$secret_key}/forRevertCron";
        // $logEntry = [
        //     'Source' => 'php-plugin',
        //     'Level' => 'Info',
        //     'Action' => 'get_word_and_link_request',
        //     'JsonData' => json_encode(['userId' => $user_id, 'api_url' => $url]),
        //     'AdditionalInfo' => 'Calling API to get word and link data',
        // ];
        // $this->postLog($logEntry);
    
        $response = wp_remote_get($url);
    
        if (is_wp_error($response)) {
            $error_message = $response->get_error_message();
            // $logEntry['Level'] = 'Error';
            // $logEntry['Action'] = 'get_word_and_link_error';
            // $logEntry['AdditionalInfo'] = 'Error occurred while fetching word and link data: ' . $error_message;
            // $this->postLog($logEntry);
            return ['error' => 'WP Error: ' . $error_message];
        }
    
        $body = wp_remote_retrieve_body($response);
        $data = json_decode($body, true);
    
        if (empty($data)) {
            $response_code = wp_remote_retrieve_response_code($response);
            // $logEntry['Level'] = 'Warning';
            // $logEntry['Action'] = 'get_word_and_link_empty_response';
            // $logEntry['AdditionalInfo'] = 'Empty response from API. Response code: ' . $response_code;
            // $this->postLog($logEntry);
            return ['error' => 'Empty response from API. Response code: ' . $response_code];
        }
    
        // $logEntry['Level'] = 'Info';
        // $logEntry['Action'] = 'get_word_and_link_response';
        // $logEntry['JsonData'] = json_encode(['response_body' => $data]);
        // $logEntry['AdditionalInfo'] = 'Received response for word and link API request';
        // $this->postLog($logEntry);
    
        return $data;
    }
    
    public function setUpdatedAtToMin($userId, $secretKey, $keyword, $url, $title) {
        // Encode query parameters
        $queryParams = http_build_query([
            'userId' => $userId,
            'secretKey' => $secretKey,
            'keyword' => $keyword,
            'url' => $url,
            'title' => $title
        ]);
    
        $apiUrl = "{$this->api_base_url}/api/WordToLink/SetUpdatedAtToMin?{$queryParams}";
        error_log('API URL: ' . $apiUrl);
    
        $response = wp_remote_post($apiUrl, [
            'body' => json_encode([]), // Adjust based on API requirements
            'headers' => [
                'Content-Type' => 'application/json',
                // Include additional headers if necessary
            ],
        ]);
    
        error_log('API Response: ' . print_r($response, true));
    
        if (is_wp_error($response)) {
            $error_message = $response->get_error_message();
            return ['error' => 'WP Error: ' . $error_message];
        }
    
        $body = wp_remote_retrieve_body($response);
        $data = json_decode($body, true);
    
        if ($response['response']['code'] !== 200) {
            return ['error' => 'API call failed with status code: ' . $response['response']['code']];
        }
    
        return $data ?: ['error' => 'Invalid or empty response from API'];
    }

    public function call_search_api($keyword, $website) {
        // Build the API URL
        $url = sprintf(
            '%s/Search?website=%s&keyword=%s',
            $this->api_base_url,
            urlencode($website),
            urlencode($keyword)
        );
    // $logEntry = [
        //     'Source' => 'php-plugin',
        //     'Level' => 'Info',
        //     'Action' => 'call_search_api_request',
        //     'JsonData' => json_encode(['keyword' => $keyword, 'website' => $website, 'api_url' => $url]),
        //     'AdditionalInfo' => 'Calling search API',
        // ];
        // $this->postLog($logEntry);
        $args = [
            'timeout' => 45 // Increase timeout to 15 seconds
        ];
        $response = wp_remote_get($url,$args);

        if (is_wp_error($response)) {
            //$error_message = $response->get_error_message();
            // $logEntry['Level'] = 'Error';
            // $logEntry['Action'] = 'call_search_api_error';
            // $logEntry['AdditionalInfo'] = 'Error occurred while calling search API: ' . $error_message;
            // $this->postLog($logEntry);
            return [];
        }
    
        // Process the response
        $body = wp_remote_retrieve_body($response);
        $data = json_decode($body, true);
    
        // Log the API response for debugging
        error_log('API Response: ' . print_r($data, true));
    
        return $data && is_array($data) ? $data : [];
    }
    
    

    //get max occurencers per article from UserDomains
    public function get_max_occurences($user_id, $secret_key) {
        $url = $this->api_base_url . "/api/UserDomains/get-max-occurences/{$user_id}/{$secret_key}";
    
        // $logEntry = [
        //     'Source' => 'php-plugin',
        //     'Level' => 'Info',
        //     'Action' => 'get_max_occurences_request',
        //     'JsonData' => json_encode(['userId' => $user_id, 'api_url' => $url]),
        //     'AdditionalInfo' => 'Calling API to get max occurrences',
        // ];
        // $this->postLog($logEntry);
    
        $response = wp_remote_get($url);
    
        if (is_wp_error($response)) {
            $error_message = $response->get_error_message();
            // $logEntry['Level'] = 'Error';
            // $logEntry['Action'] = 'get_max_occurences_error';
            // $logEntry['AdditionalInfo'] = 'Error occurred while getting max occurrences: ' . $error_message;
            // $this->postLog($logEntry);
            return ['error' => 'Error: ' . $error_message];
        }
    
        $body = wp_remote_retrieve_body($response);
        $data = json_decode($body, true);
    
        if (empty($data)) {
            $response_code = wp_remote_retrieve_response_code($response);
            // $logEntry['Level'] = 'Warning';
            // $logEntry['Action'] = 'get_max_occurences_empty_response';
            // $logEntry['AdditionalInfo'] = 'Empty response from API. Response code: ' . $response_code;
            // $this->postLog($logEntry);
            return ['error' => 'Empty response from API. Response code: ' . $response_code];
        }
    
        // $logEntry['Level'] = 'Info';
        // $logEntry['Action'] = 'get_max_occurences_response';
        // $logEntry['JsonData'] = json_encode(['response_body' => $data]);
        // $logEntry['AdditionalInfo'] = 'Received response for max occurrences request';
        // $this->postLog($logEntry);
    
        return $data['maxOccurences'];
    }
    
    public function update_word_to_link($id, $targetUrl, $isActive, $replacedKeyword = '', $occurences = 1) {
        $url = $this->api_base_url . "/api/WordToLink/word/{$id}";
    
        $body = json_encode([
            'TargetUrl' => $targetUrl,
            'IsActive' => $isActive,
            'Occurences' => $occurences,
            'ReplacedKeyword' => $replacedKeyword
        ]);
        // Log the API request
        // $log_data = array(
        //     'id' => $id,
        //     'targetUrl' => $targetUrl,
        //     'isActive' => $isActive,
        //     'api_url' => $url,
        // );
        // $logEntry = array(
        //     'Source' => 'php-plugin',
        //     'Level' => 'Info',
        //     'Action' => 'update_word_to_link_request',
        //     'JsonData' => json_encode($log_data),
        //     'UserId' => null,  // Optional: Add user ID if available
        //     'AdditionalInfo' => 'Request to update word to link target URL and activation status initiated'
        // );
        // $this->postLog($logEntry);
    
        $response = wp_remote_request($url, array(
            'method'    => 'PUT',
            'body'      => $body,
            'headers'   => array(
                'Content-Type' => 'application/json'
            )
        ));
    
        if (is_wp_error($response)) {
            // Log the error
            $error_message = $response->get_error_message();
            // $logEntry['Level'] = 'Error';
            // $logEntry['Action'] = 'update_word_to_link_error';
            // $logEntry['AdditionalInfo'] = 'Error occurred while updating word to link: ' . $error_message;
            // $this->postLog($logEntry);
    
            return ['error' => 'WP Error: ' . $error_message];
        }
    
        $response_code = wp_remote_retrieve_response_code($response);
    
        // Log the API response
        // $log_data['response_code'] = $response_code;
        // $logEntry['Action'] = 'update_word_to_link_response';
        // $logEntry['JsonData'] = json_encode($log_data);
        // $logEntry['AdditionalInfo'] = 'Response received for update word to link request';
        // $this->postLog($logEntry);
    
        if ($response_code !== 204) {  // NoContent (204) means successful PUT request with no body
            return ['error' => 'Failed to update WordToLink. Response code: ' . $response_code];
        }
    
        return ['success' => true];
    }
    


    public function get_latest_version() {
        $response = wp_remote_get($this->api_base_url . '/api/version');
        
        if (is_wp_error($response)) {
            return false;
        }
        
        $body = wp_remote_retrieve_body($response);
        return trim($body); // Remove any surrounding whitespace
    }

    public function get_word_and_link_for_canceled_subscription_cron($user_id, $secret_key) {
        $secret_key = get_option('word_replacer_secret_key');
        if (!$secret_key) {
            return ['error' => 'No secret key found'];
        }
        $url = $this->api_base_url . "/api/WordToLink/User/{$user_id}/{$secret_key}/forCanceledSubscriptionCron";
        error_log('API URL for canceled subscription cron: ' . print_r($url, true));

        $response = wp_remote_get($url);

        if (is_wp_error($response)) {
            $error_message = $response->get_error_message();
            return ['error' => 'WP Error: ' . $error_message];
        }

        $body = wp_remote_retrieve_body($response);
        $data = json_decode($body, true);

        if (empty($data)) {
            $response_code = wp_remote_retrieve_response_code($response);
            return ['error' => 'Empty response from API. Response code: ' . $response_code];
        }
        error_log('API URL data: ' . print_r($data, true));
        return $data;
    }

    public function generate_article($article_data) {
        // Flag pentru development/testing
        $use_mock_response = false;

        if ($use_mock_response) {
            // Răspuns hardcodat pentru testing
            return [
                'topic' => $article_data['topic'],
                'content' => [
                    'htmlContent' => '<h1>Test Mail 13 Februarie: Inovație în Marketing Digital</h1>
                        <p>În era digitală actuală, <strong>test mail 13 februarie</strong> reprezintă o componentă esențială în strategiile de marketing modern. Acest articol explorează impactul și importanța acestui instrument în peisajul digital contemporan.</p>
                        <h2>Importanța Test Mail 13 Februarie în Marketing</h2>
                        <p>Conceptul de <strong>test mail 13 februarie</strong> a evoluat semnificativ în ultimii ani. Această abordare permite companiilor să își optimizeze campaniile de email marketing și să obțină rezultate mai bune în comunicarea cu clienții lor.</p>
                        <p>Un aspect important al <strong>test mail 13 februarie</strong> este capacitatea sa de a oferi insights valoroase despre comportamentul utilizatorilor. Această informație este crucială pentru dezvoltarea unor strategii de marketing mai eficiente.</p>
                        <h2>Implementarea Strategiei</h2>
                        <p>Pentru a implementa cu succes <strong>test mail 13 februarie</strong>, companiile trebuie să urmeze câțiva pași esențiali. Aceștia includ analiza datelor, segmentarea audienței și optimizarea continuă a conținutului.</p>
                        <p>În concluzie, <strong>test mail 13 februarie</strong> rămâne un instrument vital în arsenalul oricărui marketer digital modern. Cu o implementare corectă, poate duce la îmbunătățiri semnificative în performanța campaniilor de marketing.</p>',
                    'tfIdfScore' => '0.85',
                    'title' => 'Test Mail 13 Februarie: Inovație în Marketing Digital'
                ]
            ];
        }

        // Codul original pentru API call rămâne aici
        $endpoint = $this->api_base_url . '/api/Article/generate-for-plugin';
        
        // Log the request data
        error_log('Article generation request data: ' . print_r($article_data, true));
        
        // Add the secret key to the request
        $article_data['secretKey'] = get_option('word_replacer_secret_key');
        $article_data['publisherDomain'] = parse_url(home_url(), PHP_URL_HOST);
        
        // Log the complete request data
        error_log('Complete article generation request: ' . print_r($article_data, true));
        
        // Increase timeout for article generation
        $response = wp_remote_post($endpoint, array(
            'method'    => 'POST',
            'timeout'   => 120, // Increase timeout to 120 seconds
            'body'      => json_encode($article_data),
            'headers'   => array(
                'Content-Type' => 'application/json'
            ),
            'sslverify' => false, // Add this if SSL verification is causing issues
            'httpversion' => '1.1', // Use HTTP 1.1
            'blocking'    => true, // Ensure the request is blocking
            'cookies'     => array()
        ));

        if (is_wp_error($response)) {
            $error_message = $response->get_error_message();
            error_log('Article generation WP error: ' . $error_message);
            
            // Add more detailed error logging
            if (strpos($error_message, 'Operation timed out') !== false) {
                error_log('Article generation timed out. Consider increasing timeout value.');
                return ['error' => 'The request took too long to complete. Please try again.'];
            }
            
            if (strpos($error_message, 'Failed to connect') !== false) {
                error_log('Article generation failed to connect to the server.');
                return ['error' => 'Could not connect to the article generation service. Please try again.'];
            }
            
            return ['error' => $error_message];
        }

        $body = wp_remote_retrieve_body($response);
        $status_code = wp_remote_retrieve_response_code($response);
        $headers = wp_remote_retrieve_headers($response);
        
        // Log the complete response information
        error_log('Article generation response code: ' . $status_code);
        error_log('Article generation response headers: ' . print_r($headers, true));
        error_log('Article generation response body: ' . $body);

        // Check for specific HTTP status codes
        if ($status_code === 504) {
            error_log('Article generation gateway timeout');
            return ['error' => 'The service took too long to respond. Please try again.'];
        }
        
        if ($status_code === 503) {
            error_log('Article generation service unavailable');
            return ['error' => 'The service is temporarily unavailable. Please try again later.'];
        }
        
        if ($status_code !== 200) {
            error_log('Article generation unexpected status code: ' . $status_code);
            return ['error' => 'Unexpected response from the service. Please try again.'];
        }

        $data = json_decode($body, true);
        
        // Log any JSON decode errors
        if (json_last_error() !== JSON_ERROR_NONE) {
            $json_error = json_last_error_msg();
            error_log('JSON decode error: ' . $json_error);
            return ['error' => 'Invalid response format: ' . $json_error];
        }
        
        if (empty($data)) {
            error_log('Article generation returned empty data');
            return ['error' => 'No content was generated. Please try again.'];
        }
        
        return $data;
    }

    public function get_article_form_information($wtl_id, $secret_key) {
        $url = $this->api_base_url . "/api/article/get-article-form-information/{$wtl_id}/{$secret_key}";
        
        error_log('Fetching article form info from: ' . $url);
        
        // Set up the request arguments
        $args = array(
            'timeout' => 30,    // Increase timeout to 30 seconds
            'httpversion' => '1.1',
            'blocking' => true,
            'headers' => array(
                'Accept' => 'application/json',
                'Content-Type' => 'application/json'
            ),
            'sslverify' => false // Only if needed for development
        );
        
        $response = wp_remote_get($url, $args);
        
        if (is_wp_error($response)) {
            $error_message = $response->get_error_message();
            error_log('Error fetching article form information: ' . $error_message);
            
            // Return default values if API fails
            return [
                'topic' => '',
                'brand' => '',
                'industry' => '',
                'advertiserDomain' => '',
                'language' => 'ro' // Default to Romanian
            ];
        }
        
        $status_code = wp_remote_retrieve_response_code($response);
        if ($status_code !== 200) {
            error_log('API returned non-200 status code: ' . $status_code);
            return [
                'topic' => '',
                'brand' => '',
                'industry' => '',
                'advertiserDomain' => '',
                'language' => 'ro'
            ];
        }
        
        $body = wp_remote_retrieve_body($response);
        $data = json_decode($body, true);
        
        error_log('Article form API response: ' . print_r($data, true));
        
        if (empty($data)) {
            error_log('Empty or invalid response from article form information API');
            return [
                'topic' => '',
                'brand' => '',
                'industry' => '',
                'advertiserDomain' => '',
                'language' => 'ro'
            ];
        }
        
        return $data;
    }

}