<?php

class WordReplacerArticleGenerator {
    private $api;

    public function __construct(WordReplacerAPI $api) {
        $this->api = $api;
    }

    public function render_article_form($word, $word_data) {
        // Get form information from API using WTL ID and secret key
        $wtl_id = isset($word_data['wtlId']) ? $word_data['wtlId'] : null;
        $secret_key = get_option('word_replacer_secret_key');
        
        error_log('Rendering article form with data: ' . print_r([
            'word' => $word,
            'word_data' => $word_data,
            'wtl_id' => $wtl_id,
            'has_secret_key' => !empty($secret_key)
        ], true));
        ?>
        <div class="wrap">
            <h1>Generate Article for "<?php echo esc_html($word); ?>"</h1>
            
            <form id="article-generator-form" class="form-loading">
                <div id="form-loading-message" style="text-align: center; margin-bottom: 20px; color: #666;">
                    Loading information...
                </div>
                
                <?php
                // Ensure we have all required data
                $link = isset($word_data['link']) ? $word_data['link'] : '';
                $title = isset($word_data['title']) ? $word_data['title'] : '';
                $typeOfLink = isset($word_data['typeOfLink']) ? $word_data['typeOfLink'] : 'NormalFollow';
                $wtlId = isset($word_data['wtlId']) ? $word_data['wtlId'] : '';
                
                // Create example HTML link
                $example_link = sprintf(
                    '<a href="%s" title="%s"%s>%s</a>',
                    esc_attr($link),
                    esc_attr($title),
                    $typeOfLink === 'NoFollow' ? ' rel="nofollow"' : '',
                    esc_html($word)
                );
                ?>
                <input type="hidden" name="keyword" value="<?php echo esc_attr($word); ?>">
                <input type="hidden" name="publisherDomain" value="<?php echo esc_attr(parse_url(home_url(), PHP_URL_HOST)); ?>">
                <input type="hidden" name="link" value="<?php echo esc_attr($link); ?>">
                <input type="hidden" name="title" value="<?php echo esc_attr($title); ?>">
                <input type="hidden" name="typeOfLink" value="<?php echo esc_attr($typeOfLink); ?>">
                <input type="hidden" name="wtlId" value="<?php echo esc_attr($wtlId); ?>">
                
                <!-- Add example link preview -->
                <table class="form-table">
                    <tr>
                        <th><label>How the link will look like (HTML)</label></th>
                        <td>
                            <input type="text" 
                                   class="regular-text" 
                                   value="<?php echo esc_attr($example_link); ?>" 
                                   disabled
                                   style="width: 100%; font-family: monospace; background-color: #f0f0f1;">
                            <p class="description">This is how the HTML link will be inserted in the article when you select a keyword.</p>
                        </td>
                    </tr>

                    <!-- Rest of the form fields -->
                    <tr>
                        <th><label for="word-count">Word Count</label></th>
                        <td>
                            <input type="number" 
                                   id="word-count" 
                                   name="wordCount" 
                                   min="2000" 
                                   max="3000" 
                                   value="2000" 
                                   required>
                            <p class="description">Number of words in the generated article (2000-3000)</p>
                        </td>
                    </tr>
                    <tr>
                        <th><label for="topic">Topic</label></th>
                        <td>
                            <input type="text" id="topic" name="topic" class="regular-text" required 
                                   value="<?php echo esc_attr($form_info['topic'] ?? ''); ?>">
                            <p class="description">Main topic or subject of the article</p>
                        </td>
                    </tr>
                    <tr>
                        <th><label for="brand">Brand</label></th>
                        <td>
                            <input type="text" id="brand" name="brand" class="regular-text" 
                                   value="<?php echo esc_attr($form_info['brand'] ?? ''); ?>">
                            <p class="description">Brand name (if applicable)</p>
                        </td>
                    </tr>
                    <tr>
                        <th><label for="industry">Industry</label></th>
                        <td>
                            <input type="text" id="industry" name="industry" class="regular-text" 
                                   value="<?php echo esc_attr($form_info['industry'] ?? ''); ?>">
                            <p class="description">Industry or business sector</p>
                        </td>
                    </tr>
                    <tr>
                        <th><label for="advertiser-domain">Advertiser Domain</label></th>
                        <td>
                            <input type="text" 
                                   id="advertiser-domain" 
                                   name="advertiserDomain" 
                                   class="regular-text" 
                                   value="<?php echo esc_attr($form_info['advertiserDomain'] ?? ''); ?>">
                            <p class="description">Domain of the advertiser (e.g., example.com)</p>
                        </td>
                    </tr>
                    <tr>
                        <th><label for="initial-information">Initial Information</label></th>
                        <td>
                            <textarea id="initial-information" name="initialInformation" rows="4" class="regular-text"></textarea>
                            <p class="description">Additional context or information for the article</p>
                        </td>
                    </tr>
                    <tr>
                        <th><label for="language">Language</label></th>
                        <td>
                            <input type="text" 
                                   id="language" 
                                   name="language" 
                                   class="regular-text" 
                                   required 
                                   value="<?php echo esc_attr($form_info['language'] ?? ''); ?>"
                                   placeholder="e.g. English, Romanian, French">
                            <p class="description">Enter the article language (e.g. English, Romanian, French)</p>
                        </td>
                    </tr>
                </table>

                <div class="submit-button">
                    <button type="submit" class="button button-primary">Generate Article</button>
                </div>
            </form>

            <div id="article-preview" class="article-preview" style="display: none;">
                <h2>Article Preview</h2>
                
                <!-- Add view toggle buttons -->
                <div class="view-toggle-buttons">
                    <button type="button" class="button view-mode-btn active" data-mode="preview">View Preview</button>
                    <button type="button" class="button view-mode-btn" data-mode="html">View HTML</button>
                </div>
                
                <div id="article-title"></div>
                
                <!-- Add containers for both views -->
                <div id="article-content-preview" class="article-view"></div>
                <div id="article-content-html" class="article-view" style="display: none;">
                    <textarea readonly style="width: 100%; min-height: 400px;"></textarea>
                </div>
            </div>

            <div id="article-controls" style="display:none;">
                <p class="description">Click on keywords in the article to toggle link placement. Selected keyword will be replaced with the right link.</p>
                <div class="publish-controls">
                    <p><strong>Selected keywords to link:</strong> <span id="selected-count">0</span></p>
                    <button id="publish-article-btn" class="button button-primary" style="display:none;">
                        Publish Article
                    </button>
                    <div id="publish-error" class="error-message" style="display:none; margin-top: 10px; color: #dc3232;"></div>
                </div>
            </div>
        </div>
        <?php
    }
} 