<?php

class WordReplacerContentProcessor {
    private $db;
    private $api;

    private $excluded_words = [
        // Common words that shouldn't be partially matched
        'pentru', 'din', 'care'
    ];

    public function __construct(WordReplacerDB $db, WordReplacerAPI $api) {
        $this->db = $db;
        $this->api = $api;
    }

    // Add method to manage excluded words
    // public function add_excluded_word($word) {
    //     $word = strtolower(trim($word));
    //     if (!in_array($word, $this->excluded_words)) {
    //         $this->excluded_words[] = $word;
    //     }
    // }

    // public function remove_excluded_word($word) {
    //     $word = strtolower(trim($word));
    //     $key = array_search($word, $this->excluded_words);
    //     if ($key !== false) {
    //         unset($this->excluded_words[$key]);
    //         $this->excluded_words = array_values($this->excluded_words);
    //     }
    // }

    // public function get_excluded_words() {
    //     return $this->excluded_words;
    // }

    private function is_excluded_word($word) {
        return in_array(strtolower(trim($word)), $this->excluded_words);
    }

    // //not used
    // public function process_content($content) {
    //     $active_words = $this->db->get_active_words();
        
       
    //     foreach ($active_words as $word_data) {
    //         error_log(sprintf(
    //             "Processing word: %s, link: %s, maxOccurences: %d",
    //             $word_data['word'] ?? 'N/A',
    //             $word_data['link'] ?? 'N/A',
    //             $word_data['max_occurrences'] ?? 0
    //         ));

    //         if (isset($word_data['word'], $word_data['link'], $word_data['max_occurrences'])) {
    //             $max_occurrences = intval($word_data['max_occurrences']);
    //             $content = $this->replace_word_in_content($content, $word_data['word'], $word_data['link'], $max_occurrences);
    //         } else {
    //             error_log("Skipping word replacement due to missing data: " . print_r($word_data, true));
    //         }
    //     }
    
    //     return $content;
    // }

    public function replace_word_in_content($content, $word, $link, $max_occurrences, $title, $typeOfLink) {
        // Log the start of word replacement
        // $log_data = array(
        //     'word' => $word,
        //     'link' => $link,
        //     'maxOccurences' => $max_occurrences,
        //     'old_content' => $content // Store the old content for logging
        // );
        // $logEntry = array(
        //     'Source' => 'php-plugin',
        //     'Level' => 'Info',
        //     'Action' => 'replace_word_in_content_start',
        //     'JsonData' => json_encode($log_data),
        //     'UserId' => null,
        //     'AdditionalInfo' => 'Starting word replacement in content'
        // );
        // $this->api->postLog($logEntry);
    
        $rel_attribute = '';
    
        switch ($typeOfLink) {
            case 'NormalFollow':
                break;
            case 'NoFollow':
                $rel_attribute = ' rel="nofollow"';
                break;
            case 'UGC':
                $rel_attribute = ' rel="ugc"';
                break;
            case 'Sponsored':
                $rel_attribute = ' rel="sponsored"';
                break;
            case 'External':
                // We'll set target="_blank" for all links, so this case is no longer special
                break;
        }

        $replacement_callback = function ($matches) use ($link, $rel_attribute, $title) {
            return sprintf(
                '<a href="%s"%s target="_blank" title="%s">%s</a>',
                esc_url($link),
                $rel_attribute,
                esc_attr($title),
                $matches[0] // Keep the original matched word
            );
        };

        // First try exact match
        $escaped_word = preg_quote(trim($word), '/');
        $diacritic_alternatives = $this->create_diacritic_alternatives(trim($word));
        $exact_regex = '/(?<![\p{L}"])(?:' . $escaped_word . '|' . $diacritic_alternatives . ')(?![\p{L}"])(?![^<]*>)(?![^<]*(?:<\/a>|<\/?h[1-6]>|<\/?quote>))/iu';
        
        // Check if exact match exists
        if (preg_match($exact_regex, $content, $exact_matches)) {
            $count = 0;
            $replaced_word = $exact_matches[0]; // Store the actual matched word
            
            $callback = function($matches) use ($replacement_callback, $max_occurrences, &$count, &$replaced_word) {
                if ($count < $max_occurrences) {
                    $count++;
                    $replaced_word = $matches[0]; // Update with the actual text being replaced
                    return $replacement_callback($matches);
                }
                return $matches[0];
            };
            
            $new_content = preg_replace_callback($exact_regex, $callback, $content);
            
            $log_data = [
                'word' => $word,
                'match_type' => 'exact',
                'replacement_count' => $count
            ];

            $logEntry = [
                'Source' => 'php-plugin',
                'Level' => 'Info',
                'Action' => 'replace_word_in_content_complete',
                'JsonData' => json_encode($log_data, JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES),
                'UserId' => null,
                'AdditionalInfo' => $word . ' ' . $escaped_word . ' Word replacement in content complete ' . $exact_regex . ' '
            ];
            $this->api->postLog($logEntry);

            return [
                'new_content' => $new_content,
                'count' => $count,
                'replaced_word' => $replaced_word
            ];
        }
        // Split the search word into parts
        $word_parts = explode(' ', trim($word));
        
        // Create an array to store all possible matches
        $possible_matches = [];
        foreach ($word_parts as $part) {
            if (strlen($part) >= 3 && !$this->is_excluded_word($part)) { // Only consider parts with 3 or more characters
                $possible_matches[] = $part;
            }
        }
        
        if (empty($possible_matches)) {
            return [
                'new_content' => $content,
                'count' => 0,
                'replaced_word' => ''
            ];
        }
    
        $count = 0;
        $new_content = $content;
        $partial_matches_found = false;

        foreach ($possible_matches as $match_word) {
            if ($count >= $max_occurrences) {
                break;
            }

            // Handle diacritics: create regex for the phrase
            $escaped_word = preg_quote($match_word, '/'); // Escape the word for regex
            $diacritic_alternatives = $this->create_diacritic_alternatives($match_word); // Generate diacritic alternatives
        
            // Build a single regex to match "închirieri auto" and its variations
            $regex = '/(?<![\p{L}"])(?:' . $escaped_word . '|' . $diacritic_alternatives . ')(?![\p{L}"])(?![^<]*>)(?![^<]*(?:<\/a>|<\/?h[1-6]>|<\/?quote>))/iu';
            // Check if this partial match exists
            if (preg_match($regex, $new_content)) {
                $partial_matches_found = true;
                
                $callback = function($matches) use ($replacement_callback, $max_occurrences, &$count, &$replaced_word) {
                    if ($count < $max_occurrences) {
                        $count++;
                        $replaced_word = $matches[0]; // Update with the actual text being replaced
                        return $replacement_callback($matches);
                    }
                    return $matches[0];
                };
                
                $new_content = preg_replace_callback($regex, $callback, $new_content);
            }
        
        }

        if (!$partial_matches_found) {
            return [
                'new_content' => $content,
                'count' => 0,
                'replaced_word' => ''
            ];
        }

        // Log the result of the word replacement
        $log_data['replacement_count'] = $count;
        $log_data['new_content'] = $new_content; // Store the new content for logging
        $logEntry = array(
            'Source' => 'php-plugin',
            'Level' => 'Info',
            'Action' => 'replace_word_in_content_complete',
            'JsonData' => json_encode($log_data,JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES), //todo good way to save in db
            'UserId' => null,
            'AdditionalInfo' => $word . ' ' . $escaped_word . ' Word replacement in content complete ' . $regex . ' '
        );
        $this->api->postLog($logEntry);
    
        return [
            'new_content' => $new_content,
            'count' => $count,
            'replaced_word' => $replaced_word ?? ''
        ];
    }
    
    // Helper function to create alternative forms of a word with diacritics
    private function create_diacritic_alternatives($phrase) {
        // Initialize an array to hold the regex parts for diacritic variations
        $diacritic_parts = [];
    
        // Map for diacritic letters
        $diacritic_map = [
            'i' => '(?:[iî])',  // Matches 'i' or 'î'
            'n' => '(?:[n])',    // Matches 'n'
            'c' => '(?:[cç])',   // Matches 'c' or 'ç'
            'h' => '(?:[h])',    // Matches 'h'
            'r' => '(?:[r])',    // Matches 'r'
            'e' => '(?:[eéêë])',  // Matches 'e', 'é', 'ê', 'ë'
            'a' => '(?:[aăâ])',   // Matches 'a', 'ă', 'â'
            'u' => '(?:[u])',     // Matches 'u'
            't' => '(?:[tț])',     // Matches 't' or 'ț'
            'o' => '(?:[oóôö])',   // Matches 'o', 'ó', 'ô', 'ö'
            's' => '(?:[sș])',   // Matches 's' or 'ș'

            'î' => '(?:[iî])',  // Matches 'i' or 'î'
            'n' => '(?:[n])',    // Matches 'n'
            'c' => '(?:[cç])',   // Matches 'c' or 'ç'
            'h' => '(?:[h])',    // Matches 'h'
            'r' => '(?:[r])',    // Matches 'r'
            'e' => '(?:[eéêë])',  // Matches 'e', 'é', 'ê', 'ë'
            'â' => '(?:[aăâ])',   // Matches 'a', 'ă', 'â'
            'ă' => '(?:[aăâ])',   // Matches 'a', 'ă', 'â'
            'u' => '(?:[u])',     // Matches 'u'
            'ț' => '(?:[tț])',     // Matches 't' or 'ț'
            'o' => '(?:[oóôö])',   // Matches 'o', 'ó', 'ô', 'ö'
            'ș' => '(?:[sș])',   // Matches 's' or 'ș'

            'I' => '(?:[iî])',  // Matches 'i' or 'î'
            'N' => '(?:[n])',    // Matches 'n'
            'C' => '(?:[cç])',   // Matches 'c' or 'ç'
            'H' => '(?:[h])',    // Matches 'h'
            'R' => '(?:[r])',    // Matches 'r'
            'E' => '(?:[eéêë])',  // Matches 'e', 'é', 'ê', 'ë'
            'A' => '(?:[aăâ])',   // Matches 'a', 'ă', 'â'
            'U' => '(?:[u])',     // Matches 'u'
            'T' => '(?:[tț])',     // Matches 't' or 'ț'
            'O' => '(?:[oóôö])',   // Matches 'o', 'ó', 'ô', 'ö'
            'S' => '(?:[sș])',   // Matches 's' or 'ș'
            
            'Î' => '(?:[iî])',  // Matches 'i' or 'î'
            'N' => '(?:[n])',    // Matches 'n'
            'C' => '(?:[cç])',   // Matches 'c' or 'ç'
            'H' => '(?:[h])',    // Matches 'h'
            'R' => '(?:[r])',    // Matches 'r'
            'E' => '(?:[eéêë])',  // Matches 'e', 'é', 'ê', 'ë'
            'Â' => '(?:[aăâ])',   // Matches 'a', 'ă', 'â'
            'Ă' => '(?:[aăâ])',   // Matches 'a', 'ă', 'â'
            'U' => '(?:[u])',     // Matches 'u'
            'Ț' => '(?:[tț])',     // Matches 't' or 'ț'
            'O' => '(?:[oóôö])',   // Matches 'o', 'ó', 'ô', 'ö'
            'Ș' => '(?:[sș])',   // Matches 's' or 'ș'
            ' ' => '(?:\\s)',      // Matches space
        ];
    
        // Process each character in the phrase
        foreach (mb_str_split($phrase) as $char) {
            // If the character is in the diacritic map, add the corresponding regex part
            if (isset($diacritic_map[$char])) {
                $diacritic_parts[] = $diacritic_map[$char];
            } else {
                // For other characters, just escape them
                $diacritic_parts[] = preg_quote($char, '/');
            }
        }
    
        // Join all parts to create the complete regex for the phrase
        return implode('', $diacritic_parts);
    }
    

    public function replace_content_for_post($post_id, $word_data) {
        $post = get_post($post_id);
        if (!$post) {
            return ['success' => false, 'count' => 0, 'replaced_word' => '', 'target_url' => '', 'error_code' => 'NO_POST'];
        }

        $original_content = $post->post_content;
        $result = $this->replace_word_in_content($original_content, $word_data['word'],
                        $word_data['link'], 1,
                        $word_data['title'], $word_data['typeOfLink']);
        
        $new_content = $result['new_content'];
        $count = $result['count'];
        $replaced_word = $result['replaced_word'];
        
        if ($new_content !== $original_content) {
            $update_result = wp_update_post([
                'ID' => $post_id,
                'post_content' => $new_content,
                'post_status' => 'publish',
            ]);

            if (!is_wp_error($update_result)) {
                $target_url = get_permalink($post_id);
                $this->db->add_history($post_id, $word_data['word'], $word_data['link'], $original_content, $new_content);
                return [
                    'success' => true, 
                    'count' => $count,
                    'replaced_word' => $replaced_word,
                    'target_url' => $target_url
                ];
            }
        }

        return [
            'success' => false, 
            'count' => 0, 
            'replaced_word' => '', 
            'target_url' => '',
            'error_code' => 'NO_MATCH'
        ];
    }
    
    public function revert_content_for_post($post_id, $word, $link) {
        $post = get_post($post_id);
        if (!$post) {
            return ['success' => false, 'target_url' => ''];
        }
    
        $current_content = $post->post_content;
    
        // Escape the word and link for regex
        $escaped_word = preg_quote(trim($word), '/');
        $escaped_link = preg_quote($link, '/');
        $diacritic_alternatives = $this->create_diacritic_alternatives(trim($word));
        
        // Pattern to match exact linked words
        $exact_pattern = '<a[^>]*href="' . $escaped_link . '"[^>]*>\s*(' . $escaped_word . '|' . $diacritic_alternatives . ')\s*<\/a>';
        
        // Check and replace exact matches
        if (preg_match('/' . $exact_pattern . '/iu', $current_content)) {
            $new_content = preg_replace_callback(
                '/' . $exact_pattern . '/iu',
                function ($matches) {
                    return $matches[1]; // Return only the original word
                },
                $current_content
            );
    
            if ($new_content !== $current_content) {
                $update_result = wp_update_post([
                    'ID' => $post_id,
                    'post_content' => $new_content,
                    'post_status' => 'publish', // Ensure the post remains published
                ]);
    
                if (!is_wp_error($update_result)) {
                    $this->db->remove_history($post_id, $word, $link);
                    return [
                        'success' => true,
                        'target_url' => get_permalink($post_id)
                    ];
                }
            }
        }
    
        // Handle partial matches if no exact matches found
        $word_parts = explode(' ', trim($word));
        $patterns = [];
    
        foreach ($word_parts as $part) {
            if (strlen($part) >= 3 && !$this->is_excluded_word($part)) {
                $escaped_part = preg_quote($part, '/');
                $diacritic_alternatives_part = $this->create_diacritic_alternatives($part);
                $patterns[] = '<a[^>]*href="' . $escaped_link . '"[^>]*>\s*(' . $escaped_part . '|' . $diacritic_alternatives_part . ')\s*<\/a>';
            }
        }
    
        if (!empty($patterns)) {
            $combined_pattern = '/' . implode('|', $patterns) . '/iu';
    
            // Check and replace partial matches
            if (preg_match($combined_pattern, $current_content)) {
                $new_content = preg_replace_callback(
                    $combined_pattern,
                    function ($matches) {
                        return $matches[1]; // Return only the original word
                    },
                    $current_content
                );
    
                if ($new_content !== $current_content) {
                    $update_result = wp_update_post([
                        'ID' => $post_id,
                        'post_content' => $new_content,
                        'post_status' => 'publish', // Ensure the post remains published
                    ]);
    
                    if (!is_wp_error($update_result)) {
                        $this->db->remove_history($post_id, $word, $link);
                        return [
                            'success' => true,
                            'target_url' => get_permalink($post_id)
                        ];
                    }
                }
            }
        }
    
        return ['success' => false, 'target_url' => ''];
    }

    // Or create a new public method specifically for article content
    public function process_article_content($content, $word_data) {
        return $this->replace_word_in_content(
            $content,
            $word_data['word'],
            $word_data['link'],
            -1, // No limit on occurrences for articles
            $word_data['title'],
            $word_data['typeOfLink']
        );
    }
}