<?php
// If uninstall is not called from WordPress, exit
if (!defined('WP_UNINSTALL_PLUGIN')) {
    exit;
}

// Load the WordReplacerDB class
require_once plugin_dir_path(__FILE__) . 'includes/class-word-replacer-db.php';

// Perform uninstallation actions
function word_replacer_uninstall() {
    global $wpdb;

    // Remove plugin options
    delete_option('word_replacer_user_id');

    // Remove custom database tables
    $history_table = $wpdb->prefix . 'word_replacer_history';
    $active_words_table = $wpdb->prefix . 'word_replacer_active_words';

    $wpdb->query("DROP TABLE IF EXISTS $history_table");
    $wpdb->query("DROP TABLE IF EXISTS $active_words_table");

    // Clear any cached data
    wp_cache_flush();
}

word_replacer_uninstall();